const createMultipliers = () => {
	document.querySelectorAll('.frm__multiplier').forEach(multiplierEl => {
		if (multiplierEl.inited === true) {
			return;
		}

		multiplierEl.inited = true;

		createMultiplier(multiplierEl);
	});
}

const createMultiplier = (wrap) => {
	const data = JSON.parse(wrap.dataset.multiplier);

	const legend     = document.createElement('legend');
	legend.innerText = data.fieldsetLegend;

	wrap.append(legend);
	wrap.multiplierData = data;

	const row = document.createElement('div');
	row.classList.add('row', 'mb-1');

	let col;

	col = document.createElement('div');
	col.classList.add('col');

	for (let name in wrap.multiplierData.fields) {
		let inputData = wrap.multiplierData.fields[name];
		let inputCol  = col.cloneNode(true);

		inputCol.innerText = inputData.label;

		row.append(inputCol);
	}
	wrap.append(row);

	const rowAddBtn = document.createElement('div');
	rowAddBtn.classList.add('row');
	rowAddBtn.innerHTML =
		'<div class="col"><a href="javascript:;" class="frm__multiplier--add btn btn-xs btn-success"><span class="fa fa-plus"></span></a></div>';
	wrap.append(rowAddBtn);

	loadDefaults(wrap);
}

const loadDefaults = (wrap, data) => {
	const defaults = wrap.dataset.default ? JSON.parse(wrap.dataset.default) : [];

	for (let i in defaults) {
		const item = defaults[i];

		createRow(wrap, item);
	}
}

const createRow = (wrap, defaults) => {
	const row = document.createElement('div');
	row.classList.add('row', 'mb-3');

	let col;
	let input;
	let remove;
	let inputCol;

	col = document.createElement('div');
	col.classList.add('col');

	for (let name in wrap.multiplierData.fields) {
		const inputData = wrap.multiplierData.fields[name];

		input = document.createElement(inputData.el);
		input.setAttribute('name', wrap.multiplierData['name'] + '[' + name + '][]');

		for (let attrName in inputData.attrs) {
			input.setAttribute(attrName, inputData.attrs[attrName]);
		}

		if (defaults && defaults[name] !== undefined) {
			input.value = defaults[name];
		}

		inputCol = col.cloneNode(true);

		inputCol.append(input);
		row.append(inputCol);
	}

	remove = document.createElement('a');
	remove.setAttribute('href', 'javascript:;');
	remove.classList.add('ml-2', 'btn', 'btn-xs', 'btn-danger', 'frm__multiplier--remove');
	remove.innerHTML = '<span class="fa fa-times"></span>';

	if (typeof inputCol === "object") {
		inputCol.classList.add('d-flex');
		inputCol.append(remove);
	}

	const addBtnRow = wrap.querySelector('.frm__multiplier--add').closest('.row');
	addBtnRow.parentNode.insertBefore(row, addBtnRow);
}

document.addEventListener('click', e => {
	const target = e.target;

	if (target.classList.contains('frm__multiplier--add')) {
		const wrap = target.closest('.frm__multiplier');

		createRow(wrap);
	} else if (target.classList.contains('frm__multiplier--remove')) {
		target.closest('.row').remove();
	}
});

document.addEventListener('DOMContentLoaded', e => {
	createMultipliers();
});

// Kvůli kompatibilitě s jquery
window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
	createMultipliers();
});

global.naja.addEventListener('complete', e => {
	createMultipliers();
});
