import Sortable, {AutoScroll} from 'sortablejs/modular/sortable.core.esm.js';

Sortable.mount(new AutoScroll());

export default class SortableLists {
	constructor() {
		this.list = [];
		this.init();
	}

	init() {
		document.querySelectorAll('[data-sortable]:not(.init)').forEach(el => {
			el.classList.add('init');
			this.list.push(new SortableList(el));
		});
	};
}

class SortableList {
	constructor(wrap) {
		const self = this;
		this.wrap = wrap;

		if (wrap.dataset.sortableTree) {
			this.sortableTree = document.querySelector(wrap.dataset.sortableTree);
			this.link = this.sortableTree.dataset.sortableLink;
		}

		this.sortable = new Sortable(self.wrap, {
			animation: 150,
			handle: '[data-sortable-handle]',
			filter: '[data-sortable-ignore]',
			draggable: '[data-sortable-item]',
			onEnd: e => {
				this.updatePosition(e);
			},
		});
	}

	updatePosition(e) {
		if (this.sortableTree)
			this.updatePositionTree(e);
	}

	updatePositionTree(e) {
		let tmp = [e.newIndex, e.oldIndex];

		let move = Math.max(...tmp) - Math.min(...tmp);

		if (move == 0)
			return;

		if (e.newIndex < e.oldIndex)
			move = -move;

		global.naja.makeRequest('post', this.link, {
			id: e.item.dataset.id,
			move: move,
		});
	}
}
