CKEDITOR.plugins.add('pshkutils', {
	init: function(editor) {
		if (!CKEDITOR.pshkUtils) {
			CKEDITOR.pshkUtils = {
				/**
				 * @param name
				 * @param value
				 * @param type
				 * @param placeholder
				 * @param className
				 * @param id
				 * @returns {HTMLInputElement}
				 */
				createInput: function(name, value, type = 'text', placeholder = '', className = '', id = '') {
					let input         = document.createElement('input');
					input.id          = id;
					input.type        = type;
					input.name        = name;
					input.value       = value || '';
					input.placeholder = placeholder;
					input.className   = 'cke_dialog_ui_input_text ck-editor-input ' + className;

					return input;
				},

				/**
				 * @param name
				 * @param options
				 * @param value
				 * @param className
				 * @param id
				 * @param keyIsValue
				 * @returns {HTMLSelectElement}
				 */
				createSelect: function(name, options, value = '', className = '', id = '', keyIsValue = false) {
					let select       = document.createElement('select');
					select.id        = id;
					select.name      = name;
					select.className = 'cke_dialog_ui_input_select ck-editor-input ' + className;

					for (let key in options) {
						let option         = document.createElement('option');
						option.value       = keyIsValue ? options[key] : key;
						option.textContent = options[key];
						if (option.value === value) {
							option.selected = true;
						}
						select.appendChild(option);
					}

					return select;
				},

				/**
				 * @param text
				 * @param onclick
				 * @returns {HTMLButtonElement}
				 */
				createTextButton: function(text, onclick) {
					let button  = document.createElement('button');
					button.type = 'button';
					button.classList.add('ck-editor-btn');
					button.innerHTML = text;

					if (onclick) {
						button.onclick = function() {
							onclick();
						};
					}

					return button;
				},

				/**
				 * @param onclick
				 * @returns {HTMLButtonElement}
				 */
				createXButton: function(onclick) {
					let button  = document.createElement('button');
					button.type = 'button';
					button.classList.add('ck-editor-btn', 'ck-editor-btn--remove');
					button.innerHTML = '<i class="fas fa-trash" aria-hidden="true"></i>';

					if (onclick) {
						button.onclick = function() {
							onclick();
						};
					}

					return button;
				},

				/**
				 * @returns {HTMLSpanElement}
				 */
				createMoveButton: function() {
					let button = document.createElement('span');
					button.classList.add('ck-editor-btn', 'drag-handle');
					button.innerHTML = '<i class="fas fa-sort" aria-hidden="true"></i>';

					return button;
				}
			};
		}
	}
});
