const initTurnstile = () => {
	document.querySelectorAll('.turnstile:not(.inited)').forEach((item) => {
		item.classList.add('inited')
		item.classList.add('not-executed')
		if (!item.querySelector('style')) {
			const style = document.createElement('style');
			style.textContent = `
				.turnstile.not-executed > div {
					display: none;
				}
			`
			item.appendChild(style)
		}

		const widgetId = turnstile.render(item, {
			sitekey: item.dataset.sitekey,
			execution: 'execute',
			'error-callback': (errorCode) => {
				turnstile.reset(item)
			},
			'expired-callback': () => {
				item.classList.remove('inited')
				item.removeAttribute('data-widget-id')
				item.innerHTML = ''
				turnstile.render(item, {
					sitekey : item.dataset.sitekey,
					callback: function (token) {}
				})
			},
			'timeout-callback': () => {
				item.classList.remove('inited')
				item.removeAttribute('data-widget-id')
				item.innerHTML = ''
				turnstile.render(item, {
					sitekey : item.dataset.sitekey,
					callback: function (token) {}
				})
			}
		})

		item.dataset.widgetId = widgetId
	})
}

const executeTurnstile = (form) => {
	const cfTurnstile = form.querySelector('.turnstile.inited')

	if (cfTurnstile) {
		cfTurnstile.classList.remove('not-executed');
		cfTurnstile.querySelector('.cloudflare-placeholder')?.remove()
		const widgetId = cfTurnstile.dataset.widgetId
		if (widgetId) {
			turnstile.execute(widgetId)
		}
	}
}

const loadTurnstileScript = () => {
	if (window.turnstile) {
		initTurnstile()
		return
	}

	const script = document.createElement('script')
	script.src = 'https://challenges.cloudflare.com/turnstile/v0/api.js?render=explicit'
	script.defer = true
	script.async = true
	script.addEventListener('load', initTurnstile, false)
	document.body.appendChild(script)
}

const initFormEvents = (formsArray = null) => {
	const forms = formsArray ?? document.querySelectorAll('form:has(.turnstile)')

	forms.forEach((form) => {
		let initialized = false

		const activateTurnstile = (form) => {
			if (initialized) return
			initialized = true
			executeTurnstile(form)
		}

		form.addEventListener('focusin', (e) => activateTurnstile(form), {once: true})
		form.addEventListener('click', (e) => activateTurnstile(form), {once: true})
		form.addEventListener('keydown', (e) => activateTurnstile(form), {once: true})
	})
}

document.addEventListener('DOMContentLoaded', () => {
	loadTurnstileScript()
	initFormEvents()

	global.naja.addEventListener('complete', () => {
		try {
			document.querySelectorAll('.turnstile.inited').forEach((item) => {
				if (!item.querySelector('.cloudflare-placeholder')) {
					item.removeAttribute('data-widget-id')
					item.innerHTML = ''
					turnstile.render(item, {
						sitekey : item.dataset.sitekey,
						callback: function (token) {}
					})
				}
			})
			const forms = document.querySelectorAll('form:has(.turnstile:not(.inited))')
			initTurnstile()
			initFormEvents(forms)
		} catch (e) {
		}
	})

	global.addEventListener('fancyboxAfterShow', (e) => {
		const elTurnstile = document.querySelector('.fancybox__container')?.querySelector('.turnstile')
		if (elTurnstile) {
			elTurnstile.removeAttribute('data-widget-id')
			elTurnstile.innerHTML = ''
			turnstile.render(elTurnstile, {
				sitekey : elTurnstile.dataset.sitekey,
				callback: function (token) {}
			})
		}
	})
})