import {slideDown, slideUp} from "es6-slide-up-down";

export class Utilities {
	static getSiblings(elem) {
		let siblings = [];
		let sibling  = elem.parentNode.firstChild;

		while (sibling) {
			if (sibling.nodeType === 1 && sibling !== elem) {
				siblings.push(sibling);
			}
			sibling = sibling.nextSibling
		}

		return siblings;
	};

	static parentsContainClass(el, q, maxParents) {
		let parent = el;
		for (let i = 1; i <= maxParents; i++) {
			parent = parent.parentNode;

			if (parent && parent.classList.contains(q)) {
				return parent;
			}
		}

		return false;
	}

	static pathContainClass(path, q) {
		for (let i in path) {
			let el = path[i];

			if (el.classList.contains(q)) {
				return el;
			}
		}

		return null;
	}

	static toggleClass(element, className) {
		if (element.classList.contains(className))
			return element.classList.remove(className);
		return element.classList.add(className);

	}
}

export const scrollTo = (amount) => {
	scroll({
		       top     : amount,
		       behavior: "smooth"
	       });
};

export function responsive(func) {
	func();
	window.addEventListener("resize", function () {
		func();
	})
}

export function checkMedia(mediaWith, maxmin = "max") {
	return window.matchMedia('(' + maxmin + '-width: ' + mediaWith + 'px)').matches;
}

export function responsiveOnMedia(onMediaEnter, onMediaExit, mediaWith, maxmin = "max") {
	if (checkMedia(mediaWith, maxmin)) onMediaEnter();
	window.addEventListener("resize", function () {
		if (checkMedia(mediaWith, maxmin)) onMediaEnter();
		else onMediaExit();
	})
}

export function convertRemToPixels(rem) {
	return rem * parseFloat(getComputedStyle(document.documentElement).fontSize);
}

export function arrayRemove(arr, value) {
	return arr.filter((el) => {
		return el != value;
	});
}

export const clickNotifyClose = () => {
	document.querySelectorAll('.alert .close:not(.init)').forEach((el) => {
		el.classList.add('init');
		el.addEventListener('click', (e) => {
			el.parentElement.remove();
		});
	});
};


export const menuHamburger = (hamburgerIcon, responsiveMenu) => {
	hamburgerIcon.addEventListener('click', () => {
		if (!responsiveMenu.classList.contains('active')) {
			slideDown(responsiveMenu);
			responsiveMenu.classList.add('active');
			hamburgerIcon.classList.add('top-menu__hamburger--active');

			let search = document.querySelector('.shop-header__search');
			if (search)
				search.classList.remove('active');
		} else {
			slideUp(responsiveMenu);
			responsiveMenu.classList.remove('active');
			hamburgerIcon.classList.remove('top-menu__hamburger--active');
		}
	});
};

export const menuOpenResponsiveSub = () => {
	document.querySelectorAll('[data-open-responsive-sub]').forEach(el => {
		el.addEventListener('click', () => {

			const id        = el.dataset.openResponsiveSub;
			const submenuEl = document.querySelector(`[data-responsive-sub="${id}"]`);

			if (submenuEl.classList.contains('mobil-sub-navigation__list--active')) {
				slideUp(submenuEl);
				submenuEl.classList.remove('mobil-sub-navigation__list--active');
				el.classList.remove('active');

			} else {
				slideDown(submenuEl);
				submenuEl.classList.add('mobil-sub-navigation__list--active');
				el.classList.add('active');
			}

		});
	})
};

export const addEventForChild = (parent, eventName, childSelector, cb) => {
	parent.addEventListener(eventName, function (event) {
		const clickedElement = event.target,
		      matchingChild  = clickedElement.closest(childSelector);
		if (matchingChild) cb(matchingChild)
	});
};

export const createModelWrap = (opts) => {
	const modalWrap = document.createElement('div');
	modalWrap.classList.add('modal');
	modalWrap.dataset.destroyOnClose = true;

	if (opts.cssClass) {
		modalWrap.classList.add(opts.cssClass);
	}

	const modalWrapInner = document.createElement('div');
	modalWrapInner.classList.add('modal__inner');
	modalWrap.appendChild(modalWrapInner);

	return modalWrap;
}

export const createModalTitle = (wrap, title, opts) => {
	const modalTitleWrap = document.createElement('div');
	modalTitleWrap.classList.add('modal__header', 'primary-bg-color');

	const modalTitleText     = document.createElement('span');
	modalTitleText.innerHTML = title;

	const modalTitleClose = document.createElement('div');
	modalTitleClose.classList.add('modal__close');

	modalTitleWrap.append(modalTitleText, modalTitleClose);
	wrap.append(modalTitleWrap);

	return modalTitleWrap;
}

export const createModalBody = (wrap, content, opts) => {
	const modalBodyWrap = document.createElement('div');
	modalBodyWrap.classList.add('modal__body-wrap');

	const modalBody = document.createElement('div');
	modalBody.classList.add('modal__body');

	const modalBodyInner = document.createElement('div');
	modalBodyInner.classList.add('inner');
	modalBodyInner.innerHTML = content;

	modalBody.append(modalBodyInner);
	modalBodyWrap.append(modalBody);
	wrap.append(modalBodyWrap);

	return modalBody;
}

export const openModal = (title, content, opts) => {
	opts = opts || {};

	const darker    = document.querySelector('.darker');
	const modalWrap = createModelWrap(opts);

	const modalTitle = createModalTitle(modalWrap.children[0], title, opts);
	const modalBody  = createModalBody(modalWrap.children[0], content, opts);

	document.body.append(modalWrap);
	darker.classList.add('darker--active');
	modalWrap.classList.add('modal--active');

	return modalWrap;
}
