<?php declare(strict_types = 1);

/** @var \Nette\Bootstrap\Configurator $configurator */

use Nette\Neon\Neon;
use Nette\Utils\FileSystem;

$cacheFile = TMP_DIR . '/pshkPackages.cache';
$loaded    = false;

if (file_exists($cacheFile)) {
	if (!$configurator->isDebugMode()) {
		$packages = unserialize(file_get_contents($cacheFile), ['allowed_classes' => false]);

		if (is_array($packages) && count($packages) > 0) {
			$loaded = true;

			foreach ($packages as $neonFile) {
				$configurator->addConfig($neonFile);
			}
		}
	}
} else {
	if (!defined('UPLOADS_DIR')) {
		throw new Exception('Constant UPLOADS_DIR missing in Bootstrap file. Default is "UPLOADS_DIR . \'/www/uploads\'"');
	}

	FileSystem::createDir(UPLOADS_DIR);

	if (!defined('THUMBS_DIR')) {
		throw new Exception('Constant THUMBS_DIR missing in Bootstrap file. Default is "THUMBS_DIR . \'/www/thumbs\'"');
	}

	FileSystem::createDir(THUMBS_DIR);

	if (!defined('LOG_DIR')) {
		throw new Exception('Constant LOG_DIR missing in Bootstrap file. Default is "LOG_DIR . \'/log\'"');
	}

	FileSystem::createDir(LOG_DIR);

	if (!defined('TMP_DIR')) {
		throw new Exception('Constant TMP_DIR missing in Bootstrap file. Default is "TMP_DIR . \'/temp\'"');
	}

	FileSystem::createDir(TMP_DIR);
}

if (!$loaded) {
	$filesToCache  = [];
	$packages      = [];
	$foundPackages = [];
	foreach (glob(__DIR__ . '/../*') as $file) {
		$packages[basename($file)] = $file;
	}

	$cmsNeonFile = APP_DIR . '/config/app/cms.neon';
	if (file_exists($cmsNeonFile)) {
		foreach (Neon::decodeFile($cmsNeonFile)['extensions'] ?? [] as $k => $v) {
			$k = strtolower($k);

			if (!isset($packages[$k])) {
				$k = str_replace('pshk', '', $k);
			}

			if (!isset($packages[$k])) {
				continue;
			}

			$foundPackages[$k] = $packages[$k];
			unset($packages[$k]);
		}
	}

	foreach (array_merge($packages, $foundPackages) as $package) {
		$configNeon = $package . '/src/DI/config.neon';

		if (file_exists($configNeon)) {
			$filesToCache[] = $configNeon;

			$configurator->addConfig($configNeon);
		}
	}

	file_put_contents($cacheFile, serialize($filesToCache));
}
