<?php declare(strict_types = 1);

namespace Core\AdminModule\Components\ContentLangSwitcher;

use Core\Model\SystemConfig;
use Core\Model\UI\BaseControl;
use Nette\Http\Request;

class ContentLangSwitcher extends BaseControl
{
	public string  $templateFile = 'Default';
	public ?string $title        = null;

	public function __construct(
		protected Request $httpRequest,
	)
	{
	}

	public function render(): void
	{
		$langs = $this->getLangs();

		if (count($langs) === 1) {
			return;
		}

		$this->template->title      = $this->title ?: $this->translator->translate('default.contentLangSwitcher');
		$this->template->activeLang = $this->getActiveLang();
		$this->template->langs      = $langs;
		$this->template->render($this->getTemplateFile($this->templateFile));
	}

	public function getActiveLang(): string
	{
		return $this->httpRequest->getCookie('contentLang') && (int) SystemConfig::loadScalar('rememberActiveLang') === 1
			? $this->httpRequest->getCookie('contentLang')
			: $this->translator->getLocale();
	}

	public function getLangs(): array
	{
		return $this->langsService->getLangs(false);
	}
}
