<?php declare(strict_types = 1);

namespace Core\AdminModule\Components\DashboardWidgets;

use Exception;
use Core\AdminModule\Model\EditorDataService;
use Dashboard\AdminModule\Components\Widget;
use Dashboard\AdminModule\Model\Provider\IWidget;
use Nette\Utils\Json;

class MissingEditorData extends Widget implements IWidget
{

	protected string $gridSize = 'col-md-4 col-xxl-3';

	protected string $key = 'coreMissingEditorData';

	protected EditorDataService $editorDataService;

	public function __construct(
		EditorDataService $editorDataService
	)
	{
		$this->editorDataService = $editorDataService;
	}

	public function render(): void
	{
		$this->template->key   = $this->getKey();
		$this->template->icon  = 'fas fa-list';
		$this->template->title = $this->t('admin.dashboardWidgets.missingEditorData.title');
		$this->template->data  = $this->loadData() ?: [];

		$this->template->render($this->getTemplateFile());
	}

	public function handleRefresh(): void
	{
		$this->editorDataService->runCheck();
		$this->template->data = $this->loadData() ?: [];
		$this->redrawControl('list');
	}

	protected function loadData(): ?array
	{
		$dataFile = DATA_DIR . '/core/content/missing_editor_data.json';
		if (!file_exists($dataFile)) {
			return null;
		}

		try {
			$data = Json::decode((string) file_get_contents($dataFile), Json::FORCE_ARRAY);
			if (!is_array($data)) {
				return null;
			}

			return $data;
		} catch (Exception $e) {
		}

		return null;
	}
}
