<?php declare(strict_types = 1);

namespace Core\AdminModule\Components\WebColors;

use Core\AdminModule\Components\SettingsForm;
use Core\AdminModule\Model\ColorsCompiler;
use Core\Model\Helpers\Strings;
use Core\Model\UI\AbstractPresenter;
use Core\Model\UI\Form\BaseForm;
use Nette\Utils\ArrayHash;

class ColorsForm extends SettingsForm
{
	/** @var ColorsCompiler @inject */
	public $colorsCompiler;

	public function __construct(
		protected string $siteIdent,
	)
	{
		$this->inputNamePrefix = $siteIdent;
		parent::__construct('webColors');

		$this->monitor(AbstractPresenter::class, function(AbstractPresenter $presenter) {
			$baseLayout = $this->settings->get($this->siteIdent . '_baseLayout', '', false);

			if ($baseLayout) {
				$this->namespace = 'webColors' . Strings::firstUpper($baseLayout);
			}
		});
	}

	public function render(): void
	{
		parent::render();
		$this->template->render();
	}

	protected function createComponentForm(): BaseForm
	{
		$form = parent::createComponentForm();

		$form->getComponent('saveControl')['save']->caption = 'core.colorsForm.saveAndApplyColors';

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): bool
	{
		$result = parent::formSuccess($form, $values);

		if ($result) {
			if ($this->colorsCompiler->compile($this->siteIdent)) {
				$this->presenter->flashMessageSuccess('core.colorsCompiled');
			} else {
				$this->presenter->flashMessageDanger('core.colorsCompileError');
			}

			$this->presenter->redrawControl('flashes');
		}

		return $result;
	}
}
