<?php declare(strict_types = 1);

namespace Core\AdminModule\Model;

use Core\Model\Helpers\Strings;
use Core\Model\WebColors;
use Exception;
use Nette\Utils\FileSystem;
use ScssPhp\ScssPhp\Compiler;
use ScssPhp\ScssPhp\OutputStyle;
use ScssPhp\ScssPhp\ValueConverter;

class ColorsCompiler
{
	public function __construct(
		protected WebColors $webColors,
	)
	{
	}

	public function compile(string $siteIdent = ''): bool
	{
		$this->webColors->clearCache();
		$vars = $this->webColors->getColors($siteIdent);

		$scss = new Compiler();

		try {
			$scssVars = array_map(static fn($v) => ValueConverter::parseValue($v), $vars);

			$scss->addVariables($scssVars);
			$scss->setImportPaths(SRC_DIR . '/core/assets/front/src/globalScss/');

			$filePrefix = $siteIdent === '' ? $siteIdent : $siteIdent . '_';

			$oldFile     = ASSETS_DIR . '/front/dist/' . $filePrefix . 'webColorsOld.css';
			$newFile     = ASSETS_DIR . '/front/dist/' . $filePrefix . 'webColors.css';
			$cssVarsFile = ASSETS_DIR . '/front/dist/' . $filePrefix . 'webColorsVars.css';
			$tmpFile     = TMP_DIR . '/webColors.tmp';

			$scss->setOutputStyle(OutputStyle::COMPRESSED);

			file_put_contents($tmpFile, $scss->compileString((string) file_get_contents(SRC_DIR . '/core/assets/front/src/globalScss/settings.scss'))->getCss());
			if (file_exists($newFile)) {
				FileSystem::rename($newFile, $oldFile);
			}

			FileSystem::rename($tmpFile, $newFile);
		} catch (Exception $e) {
			return false;
		}

		try {
			$tmp = [];
			foreach ($vars as $k => $v) {
				$rgb   = Strings::hexToRgb($v);
				$tmp[] = '--' . $k . ': ' . sprintf('%d %d %d;', $rgb['r'], $rgb['g'], $rgb['b']);
			}

			$scss = new Compiler();
			file_put_contents($cssVarsFile, $scss->compileString(':root{' . implode('', $tmp) . '}')->getCss());
		} catch (Exception $e) {
		}

		FileSystem::delete($tmpFile);
		FileSystem::delete(TMP_DIR . '/cache/latte');

		return true;
	}
}
