<?php declare(strict_types = 1);

namespace Core\AdminModule\Model;

use Exception;
use Core\Model\Entities\Variable;
use Core\Model\Helpers\BaseEntityService;

/**
 * @method Variable|object|null getReference($id)
 * @method Variable[]|null getAll()
 * @method Variable|null get($id)
 */
class Variables extends BaseEntityService
{
	protected $entityClass = Variable::class;

	public function __construct()
	{
	}

	public function removeByKey(string $key): bool
	{
		try {
			$this->getEr()->createQueryBuilder('v')
				->delete()
				->where('v.key = :key')
				->setParameter('key', $key)
				->getQuery()->execute();
		} catch (Exception $e) {
			return false;
		}

		return true;
	}
}
