<?php declare(strict_types = 1);

namespace Core\AdminModule\Presenters;

use Core\AdminModule\Components\Cookies\CookieBarSettings;
use Core\AdminModule\Components\Cookies\ICookieBarSettingsFactory;
use Core\AdminModule\Components\Cookies\IServicesGridFactory;
use Core\AdminModule\Components\Cookies\ServicesGrid;

class CookiesPresenter extends BasePresenter
{
	public const ICON = 'fas fa-cookie-bite';

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
		$this->setTitle($this->t('admin.title.cookies'));
		$this->setHeader('admin.title.cookies', self::ICON);

		$this['navigation']->setData([
			'header' => [
				[
					'title' => 'admin.title.addService',
					'link'  => 'cookieAdditionalServicesGrid:add!',
					'ico'   => 'plus',
					'class' => 'ajax',
				],
				[
					'title' => 'admin.title.cookieBarSettings',
					'link'  => ':openCookieBarSettings!',
					'ico'   => 'wrench',
					'class' => 'ajax',
				],
			],
		]);
	}

	public function handleOpenCookieBarSettings(): void
	{
		$this->template->modalTitle = 'admin.title.cookieBarSettings';
		$this->template->modal      = 'cookieBarSettings';
		$this->redrawControl('modal');
	}

	public function createComponentCookieAdditionalServicesGrid(IServicesGridFactory $factory): ServicesGrid
	{
		return $factory->create();
	}

	protected function createComponentCookieBarSettings(ICookieBarSettingsFactory $factory): CookieBarSettings
	{
		return $factory->create();
	}

}
