<?php declare(strict_types = 1);

namespace Core\AdminModule\Presenters;

use Core\AdminModule\Components\PublicHoliday\IPublicHolidaysGridFactory;
use Core\AdminModule\Components\PublicHoliday\PublicHolidaysGrid;

class PublicHolidayPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		if (!$this->getUser()->isAllowed($this->getName(), 'access')) {
			$this->error();
		}

		$this->setHeader('admin.title.publicHolidays', 'fas fa-umbrella-beach');
	}

	/*******************************************************************************************************************
	 * ===============================  Render
	 */

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
	}

	/*******************************************************************************************************************
	 * ===============================  Components
	 */

	protected function createComponentPublicHolidays(IPublicHolidaysGridFactory $factory): PublicHolidaysGrid
	{
		return $factory->create();
	}
}
