<?php declare(strict_types = 1);

namespace Core\AdminModule\Presenters;

use Core\AdminModule\Components\DataForm;
use Core\AdminModule\Components\IDataFormFactory;
use Core\AdminModule\Components\Settings\ISiteFormFactory;
use Core\AdminModule\Components\Settings\IWebSettingsFormFactory;
use Core\AdminModule\Components\Settings\SiteForm;
use Core\AdminModule\Components\Settings\WebSettingsForm;
use Nette\Application\BadRequestException;
use Nette\Application\UI\Multiplier;

class SettingsPresenter extends BasePresenter
{
	/**
	 * @return void
	 * @throws BadRequestException
	 */
	protected function startup()
	{
		parent::startup();
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'settings')) {
			$this->error();
		}

		$this->setHeader('admin.title.cmsSettings', 'fas fa-cogs');
	}

	public function actionGlobalData(): void
	{
		$this->setHeader('admin.title.globalData', 'fas fa-globe');
	}

	/*******************************************************************************************************************
	 * ===============================  Render
	 */

	public function renderDefault(): void
	{
		$this->template->sites = $this->sitesService->getAll();
	}

	/*******************************************************************************************************************
	 * ===============================  Components
	 */

	protected function createComponentSiteForm(ISiteFormFactory $factory): Multiplier
	{
		return new Multiplier(fn(string $ident): SiteForm => $factory->create($ident));
	}

	protected function createComponentWebSettingsForm(IWebSettingsFormFactory $factory): Multiplier
	{
		return new Multiplier(fn(string $ident): WebSettingsForm => $factory->create($ident));
	}

	protected function createComponentGlobalDataForm(IDataFormFactory $factory): DataForm
	{
		return $factory->create('globalData');
	}
}
