<?php declare(strict_types = 1);

namespace Core\AdminModule\Presenters;

use Core\AdminModule\Components\IStaticTextsFormFactory;
use Core\AdminModule\Components\StaticTextsForm;

class StaticTextsPresenter extends BasePresenter
{
	final public const ICON = 'far fa-file-alt';

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
		$this->setTitle($this->t('admin.title.staticTexts'));
		$this->setHeader('admin.title.staticTexts', self::ICON);
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */
	public function createComponentStaticTextsForm(IStaticTextsFormFactory $factory): StaticTextsForm
	{
		return $factory->create();
	}
}
