<?php declare(strict_types = 1);

namespace Core\ApiModule\Api\V1\Controllers;

use Apitte\Core\Annotation\Controller\Path;
use Apitte\Core\Annotation\Controller\Method;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Http\ApiResponse;
use Apitte\Negotiation\Http\ArrayEntity;
use Core\Model\Countries;

/**
 * @Path("/countries")
 */
class CountriesController extends BaseController
{
	protected Countries $countries;

	public function __construct(Countries $countries)
	{
		$this->countries = $countries;
	}

	/**
	 * @Path("/")
	 * @Method("GET")
	 */
	public function index(ApiRequest $request, ApiResponse $response): ApiResponse
	{
		return $response->withStatus(ApiResponse::S200_OK)->withEntity(ArrayEntity::from($this->countries->getAllNameColumn()));
	}

}