<?php declare(strict_types = 1);

namespace Core\ApiModule\Api\V1\Controllers;

use Apitte\Core\Annotation\Controller\Path;
use Apitte\Core\Annotation\Controller\Method;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Http\ApiResponse;
use Core\Model\Settings;

/**
 * @Path("/settings")
 */
class SettingsController extends BaseController
{
	protected Settings $settings;

	public function __construct(Settings $settings)
	{
		$this->settings = $settings;
	}

	/**
	 * @Path("/")
	 * @Method("GET")
	 */
	public function index(ApiRequest $request, ApiResponse $response): ApiResponse
	{
		return $response->writeJsonBody($this->settings->getAll())->withStatus(ApiResponse::S200_OK);
	}

}