<?php declare(strict_types = 1);

namespace Core\ApiModule\Api\V1\Controllers;

use Apitte\Core\Annotation\Controller\Path;
use Apitte\Core\Annotation\Controller\Method;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Http\ApiResponse;
use Core\Model\Sites;

/**
 * @Path("/site")
 */
class SiteController extends BaseController
{
	protected Sites $sites;

	public function __construct(Sites $sites)
	{
		$this->sites = $sites;
	}

	/**
	 * @Path("/current")
	 * @Method("GET")
	 */
	public function current(ApiRequest $request, ApiResponse $response): ApiResponse
	{
		$site = $this->sites->getCurrentSite();
		return $response->writeJsonBody(['site' => $site, 'defaultDomain' => $site->getDefaultDomain()])->withStatus(ApiResponse::S200_OK);
	}

}
