<?php declare(strict_types = 1);

namespace Core\ApiModule\Model\Decorators;

use Apitte\Core\Decorator\IRequestDecorator;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Http\ApiResponse;
use Contributte\Translation\Translator;

class RequestLocalizationDecorator implements IRequestDecorator
{
	protected Translator $translator;

	public function __construct(Translator $translator)
	{
		$this->translator = $translator;
	}

	private const QUERY_PARAM_LANG = 'lang';

	public function decorateRequest(ApiRequest $request, ApiResponse $response): ApiRequest
	{
		if ($request->hasQueryParam(self::QUERY_PARAM_LANG)) {
			$this->translator->setLocale($request->getQueryParam(self::QUERY_PARAM_LANG));
		}

		return $request;
	}

}