<?php declare(strict_types = 1);

namespace Core\ApiModule\Model\Utils;

use Core\Model\Parameters;
use Core\Model\SystemConfig;
use Nette\Neon\Neon;

class AppConfiguration
{
	protected static function publicConfig(): array
	{
		return Neon::decodeFile(APP_DIR . '/config/config.public.neon');
	}

	public static function testMode(): bool
	{
		return (bool) SystemConfig::loadScalar('testMode');
	}

	public static function sessionSavePath(): string
	{
		$config = self::publicConfig();

		return $config['session']['savePath'];
	}

	public static function consoleUrl(): string
	{
		$config = self::publicConfig();

		return $config['console']['url'];
	}

	public static function comgateTestMode(): ?bool
	{
		$isComgatePresent       = false;
		$comgateTestModeEnabled = false;
		$comgate                = (array) Parameters::load('comgate') ?: [];
		if ($comgate) {
			array_walk_recursive($comgate, static function($value, string $key) use ($comgateTestModeEnabled): void {
				if ($key === 'test' && $value === true) {
					$comgateTestModeEnabled = true;
				}
			});

			$isComgatePresent = true;
		}

		$config = Neon::decodeFile(APP_DIR . '/config/config.neon');
		if (is_array($config) && array_key_exists('comgate', $config)) {
			if ($config['comgate']['test'] === true) {
				$comgateTestModeEnabled = true;
			}
			$isComgatePresent = true;
		}

		return !$isComgatePresent ? null : $comgateTestModeEnabled;
	}

}
