<?php declare(strict_types = 1);

namespace Core\Components\Flashes;

use Nette\Utils\ArrayHash;
use Core\Model\Http\Session;
use Core\Model\UI\BaseControl;
use Nette;
use Nette\HtmlStringable;
use stdClass;

class Flashes extends BaseControl
{
	final public const FLASH_PRIMARY   = 'primary';
	final public const FLASH_SECONDARY = 'secondary';
	final public const FLASH_SUCCESS   = 'success';
	final public const FLASH_DANGER    = 'danger';
	final public const FLASH_WARNING   = 'warning';
	final public const FLASH_INFO      = 'info';

	protected static array $newFlashes = [];

	public function __construct(protected Session $session)
	{
	}

	public function render(array $parameters = null): void
	{
		if ($parameters) {
			$this->template->parameters = ArrayHash::from($parameters);
		}

		$presenter = $this->presenter;

		foreach (self::$newFlashes as $k => $v) {
			$presenter->flashMessage($v['message'], $v['type'], $v['duration'] ?? null);
			unset(self::$newFlashes[$k]);
		}

		$flashes = $presenter->getTemplate()->flashes;

		if ($this->session->isStarted() && $presenter->hasFlashSession()) {
			$flashSession = $presenter->getFlashSession();
			$flashSession->setExpiration('1 minute');
			$flashes = $flashSession->flash;
		}

		$this->template->flashes = $flashes ?? [];
		$this->template->render($this->getTemplateFile());
	}

	/**
     * @param string|stdClass|Nette\HtmlStringable $message
     * @param string                                $type
     * @param int                                   $duration
     *
     * @return void
     */
    public static function addFlashMessage($message, string $type, int $duration = 1500): void
	{
		self::$newFlashes[] = [
			'message'  => $message,
			'type'     => $type,
			'duration' => $duration,
		];
	}

	public static function hasNewFlashes(): bool { return (bool) count(self::$newFlashes); }
}
