<?php declare(strict_types = 1);

namespace Core\Components\JsTranslates;

use Core\Model\UI\BaseControl;

class JsTranslates extends BaseControl
{
	protected array $translates = [];

	public function render(): void
	{
		$arr = [];
		foreach ($this->translates as $k => $v) {
			if (is_array($v)) {
				$arr[$k] = $this->t(...$v);
			} else {
				$arr[$k] = $this->t($v);
			}
		}

		$this->template->data = $arr;
		$this->template->render($this->getTemplateFile());
	}

	public function addTranslate(string $k, string|array $v): self
	{
		$this->translates[$k] = $v;

		return $this;
	}

	public function addTranslates(array $data): self
	{
		$this->translates += $data;

		return $this;
	}
}
