<?php declare(strict_types = 1);

namespace Core\Console\Cache;

use Doctrine;
use Exception;
use Nette\Caching\Cache;
use Nette\Caching\Storage;
use Nette\Utils\FileSystem;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'cache:clean')]
class Clean extends Command
{
	public function __construct(
		protected Storage $cacheStorage,
	)
	{
		parent::__construct();
	}

	protected function configure(): void
	{
		$this->setName('cache:clean')->setDescription('Generate eshop catalog cache');
	}

	protected function execute(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		$output->writeln('CLEAN CACHE');

		try {
			$cache = new Cache($this->cacheStorage);
			$cache->clean([Cache::ALL => true]);
			FileSystem::delete(TMP_DIR);
			FileSystem::createDir(TMP_DIR);

			$output->writeLn('<info>[OK]</info>');
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
