<?php declare(strict_types = 1);

namespace Core\Console\Seo;

use Core\FrontModule\Model\SiteMap;
use Core\Model\Lang\Langs;
use Doctrine;
use Exception;
use Nette\Application\LinkGenerator;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'seo:generate-robots-txt')]
class GenerateRobotsTxt extends Command
{
	public function __construct(
		protected SiteMap       $siteMap,
		protected LinkGenerator $linkGenerator,
		protected Langs         $langs,
	)
	{
		parent::__construct();
	}

	protected function configure(): void
	{
		$this->setName('seo:generate-robots-txt')->setDescription('Generate robots.txt');
	}

	protected function execute(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		$output->writeln('GENERATE ROBOTS.TXT');

		try {
			$content = "User-agent: *\n" .
				"Disallow: /admin\n" .
				"Disallow: /assets/admin\n" .
				"Disallow: /assets/admin2\n" .
				"Disallow: /*?do=measuringCodesTurnOn\n" .
				"Disallow: /trafficbot.life\n";

			$content .= "\n";

			file_put_contents(WWW_DIR . '/robots.txt', $content);

			$output->writeLn('<info>[OK] - robots.txt created</info>');
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
