<?php declare(strict_types = 1);

namespace Core\Console\Utils;

use Core\AdminModule\Model\Redirects;
use Doctrine;
use Exception;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'utils:validate-redirects')]
class ValidateRedirects extends Command
{
	public function __construct(
		protected Redirects $redirects,
	)
	{
		parent::__construct();
	}

	protected function configure(): void
	{
		$this->setName('utils:validate-redirects')
			->addOption('offset', null, InputOption::VALUE_REQUIRED)
			->addOption('limit', null, InputOption::VALUE_REQUIRED);
	}

	protected function executeSchema(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		$output->writeln('VALIDATE REDIRECTS');

		try {
			try {
				$this->redirects->validateRedirects(
					(int) $input->getOption('offset'),
					(int) $input->getOption('limit'),
				);
				$output->writeLn('<info>[OK] - data updated</info>');
			} catch (Exception $e) {
				$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
			}
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 0;
	}
}
