<?php declare(strict_types = 1);

namespace Core\ErrorModule\Presenters;

use Nette;
use Nette\Application\BadRequestException;
use Nette\Application\Helpers;
use Nette\Application\Request;
use Nette\Application\Response;
use Nette\Application\Responses\CallbackResponse;
use Nette\Application\Responses\ForwardResponse;
use Nette\SmartObject;
use Tracy\Debugger;
use Tracy\ILogger;
use function str_starts_with;

class ErrorPresenter extends BasePresenter
{
	use SmartObject;

	public function __construct(
		protected ILogger $logger,
	)
	{
	}

	public function run(Request $request): Response
	{
		$e = $request->getParameter('exception');

		//TODO FIX
		$file = __DIR__ . '/../templates/Error/500.phtml';

		try {
			$requestUri = (string) $_SERVER['REQUEST_URI'];
			$realIp     = $_SERVER['HTTP_X_REAL_IP'] ?? $_SERVER['REMOTE_ADDR'];
			if (str_starts_with($requestUri, '/wp')
				|| $requestUri === '/bc') {
				Debugger::log('IP: ' . (string) $realIp, 'wp');
				die();
			}

			if ($e instanceof BadRequestException) {
			} else if ($e instanceof Nette\InvalidStateException) {
				Debugger::log($e, 'invalidStateException');
			} else if ($e->getCode() == 0) {
				Debugger::log($e, ILogger::EXCEPTION);
			} else {
				$this->logger->log(
					"HTTP code {$e->getCode()}: {$e->getMessage()} in {$e->getFile()}:{$e->getLine()}",
					'access',
				);
			}

			[$module, $presenter, $sep] = Helpers::splitName($request->getPresenterName());
			$errorPresenter = $module . $sep . 'Error4xx';

			return new ForwardResponse($request->setPresenterName($errorPresenter));
		} catch (\Exception $e) {
			if (file_exists(TEMPLATES_DIR . '/Error/500.phtml')) {
				$file = TEMPLATES_DIR . '/Error/500.phtml';
			} else {
				$file = __DIR__ . '/../templates/Error/500.phtml';//TODO FIX
			}

			$this->logger->log($e, ILogger::EXCEPTION);
		}

		return new CallbackResponse(function() use ($file) {
			require $file;
		});
	}
}
