<?php declare(strict_types = 1);

namespace Core\FrontModule\Components;

use Core\Model\Mailing\TemplateFactory;
use Core\Model\Parameters;
use Core\Model\Sites;
use Core\Model\SystemConfig;
use Core\Model\Templating\Template;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Exception;
use Nette\Mail\Mailer;
use Nette\Mail\Message;
use Nette\Utils\ArrayHash;
use Nette\Utils\Validators;

/**
 * @deprecated
 */
class ContactForm extends BaseControl
{
	protected Message $message;

	public function __construct(
		protected                 $data,
		protected Mailer          $mailer,
		protected TemplateFactory $templateFactory,
		protected Sites           $sites,
	)
	{
		$this->message = new Message();

		$this->setSubject($data['subject'] ?? '');

		if (is_array($data['replyTo'])) {
			foreach ($data['replyTo'] as $email => $name) {
				if (Validators::isEmail($email)) {
					$this->addReplyTo($email, $name);
				}
			}
		}

		if (isset($data['bcc']) && Validators::isEmail($data['bcc'])) {
			foreach (explode(',', (string) $data['bcc']) as $v) {
				$this->message->addBcc(trim($v));
			}
		}
	}

	public function render(): void
	{
		$this->template->thisForm = $this['form'];
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ======================== Setters
	 */
	public function setFrom($fromEmail, $fromName = null)
	{
		$this->message->setFrom($fromEmail, $fromName);

		return $this;
	}

	public function addTo($toEmail, $toName = null)
	{
		$this->message->addTo($toEmail, $toName);

		return $this;
	}

	public function setSubject($subject)
	{
		$this->message->setSubject($subject);

		return $this;
	}

	public function addReplyTo($email, $name = null)
	{
		$this->message->addReplyTo($email, $name);

		return $this;
	}

	public function signalReceived($signal): void
	{
		parent::signalReceived($signal);
	}

	/*******************************************************************************************************************
	 * ======================== Components
	 */

	protected function createComponentForm()
	{
		$form = $this->createForm();
		$form->setAjax();
		$form->setAction($this->presenter->getHttpRequest()->getUrl()->getAbsoluteUrl());

		$form->addText('name', 'default.contactForm.name')
			->setHtmlAttribute('placeholder', $this->t('default.contactForm.name'))
			->setRequired();
		$form->addEmail('email', 'default.contactForm.email')
			->setHtmlAttribute('placeholder', $this->t('default.contactForm.email'))
			->setRequired();
		$form->addText('phone', 'default.contactForm.phone')
			->setHtmlAttribute('placeholder', $this->t('default.contactForm.phone'));
		$form->addTextArea('message', 'default.contactForm.message')
			->setHtmlAttribute('placeholder', $this->t('default.contactForm.message'))
			->setRequired();
		if (Parameters::load('contactForm.addGdprAgree')) {
			$form->addCheckbox('gdpr', 'GDPR')->setRequired();
		}

		if ($this->configService->get('useGoogleRecaptcha') === true) {
			if (SystemConfig::load('googleRecaptchaInvisible') === true) {
				$form->addInvisibleReCaptcha('recaptcha', true, 'default.formMessages.recaptcha');
			} else {
				$form->addReCaptcha('recaptcha', 'Google recaptcha', true, 'default.formMessages.recaptcha')
					->setRequired('default.formMessages.recaptchaRequired');
			}
		}

		$form->addSubmit('submit', 'default.contactForm.send');

		$form->onValidate[] = $this->formOnValidate(...);
		$form->onSuccess[]  = $this->formOnSuccess(...);

		return $form;
	}

	public function formOnValidate(BaseForm $form, ArrayHash $values)
	{
		if ($this->configService->get('useGoogleRecaptcha') === true && $form->getComponent('recaptcha')->hasErrors()) {
			$form->addError('default.formMessages.recaptcha');
		}
		if ($form->getErrors()) {
			$this->redrawControl('formErrors');
		}
	}

	public function formOnSuccess($form, ArrayHash $values)
	{
		try {
			/** @var Template $template */
			$template     = $this->templateFactory->create($this->sites->getCurrentSite()->getIdent());
			$templateFile = TEMPLATES_DIR . '/Front/default/ContactFormEmail.latte';
			$template->setFile(file_exists($templateFile) ? $templateFile : __DIR__ . '/ContactFormEmail.latte');

			$currentSite = $this->sites->getCurrentSite();
			$data        = $this->data;

			$toEmail = $data['toEmail'] == 'currentSite' ? $currentSite->getEmail() : $data['toEmail'];
			$toName  = $data['toName'] == 'currentSite' ? $currentSite->getSiteName() : $data['toName'];

			$fromEmail = $data['fromEmail'] == 'currentSite' ? $toEmail : $data['fromEmail'];
			$fromName  = $data['fromName'] == 'currentSite' ? $toName : $data['fromName'];

			$this->setFrom($fromEmail ?? null, $fromName ?? null);
			$this->addTo($toEmail ?? null, $toName ?? null);

			if (is_string($this->data['replyTo']) && $this->data['replyTo'] == 'formEmail'
				|| is_array($this->data['replyTo']) && in_array('formEmail', $this->data['replyTo']))
				$this->addReplyTo($values->email, $values->name);

			$params            = (array) $values;
			$params['subject'] = $this->message->getSubject();
			$template->setParameters($params);

			$this->message->setHtmlBody($template->renderToString());
			$this->mailer->send($this->message);

			if (isset($this->data['sendCopyToSender']) && $this->data['sendCopyToSender'] == true) {
				try {
					$this->message->clearHeader('To');
					$this->message->clearHeader('Reply-To');
					$this->message->clearHeader('Bcc');
					$this->message->addTo($values->email, $values->name);
					$this->message->addReplyTo($fromEmail, $fromName);
					$this->message->setSubject(
						$this->translator->translate(
							'default.contactForm.senderSubject',
						) . ' ' . $currentSite->getSiteName(),
					);

					$templateFile = TEMPLATES_DIR . '/Front/default/ContactFormEmail_Sender.latte';
					$template->setFile(
						file_exists($templateFile) ? $templateFile : __DIR__ . '/ContactFormEmail_Sender.latte',
					);

					$this->message->setHtmlBody($template->renderToString());
					$this->mailer->send($this->message);
				} catch (Exception) {
				}
			}

			$this->template->okMessage = $this->t('default.contactForm.formOk');
		} catch (Exception) {
			$form->addError($this->t('default.contactForm.sendingError'));

			return false;
		}

		if ($this->presenter->isAjax()) {
			$this->redrawControl('form');
		} else {
			$this->presenter->redirectUrl($this->presenter->getHttpRequest()->getUrl()->getAbsoluteUrl());
		}
	}
}
