<?php declare(strict_types = 1);

namespace Core\FrontModule\Model;

use DateTime;
use Contributte\Translation\Translator;
use Core\FrontModule\Model\Dao\PublicHoliday;
use Core\Model\Countries;
use Core\Model\Entities\EntityManagerDecorator;
use Nette\Caching\Cache;
use Nette\Caching\Storage;

class PublicHolidays
{
	protected Cache                  $cache;
	protected EntityManagerDecorator $em;
	protected Translator             $translator;
	protected Countries              $countries;

	protected array $cAll = [];

	public function __construct(
		Storage                $storage,
		EntityManagerDecorator $em,
		Translator             $translator,
		Countries              $countries
	)
	{
		$this->cache      = new Cache($storage, 'corePublicHolidays');
		$this->em         = $em;
		$this->translator = $translator;
		$this->countries  = $countries;
	}

	public function getAll(): array
	{
		$key = $this->translator->getLocale();

		if (!array_key_exists($key, $this->cAll)) {
			$this->cAll[$key] = $this->cache->load('all/' . $key, function(&$dep) {
				$dep[Cache::EXPIRE] = '1 month';

				$result = [];
				foreach ($this->em->getConnection()->fetchAllAssociative("SELECT h.date, h.country_id, ht.title, ht.description
						FROM core__public_holiday h
						LEFT JOIN core__public_holiday_text ht ON h.id = ht.public_holiday_id AND ht.lang = :lang
						WHERE h.date >= CURDATE()
						ORDER BY h.date ASC
						", [
					'lang' => $this->translator->getLocale(),
				]) as $row) {
					$date = DateTime::createFromFormat('Y-m-d', $row['date']);

					if (!$date) {
						continue;
					}

					$dao              = new PublicHoliday($date);
					$dao->title       = $row['title'] ?: null;
					$dao->description = $row['description'] ?: null;
					$dao->countryCode = $row['country_id'] ?: null;

					$result[$row['date']] = $dao;
				}

				return $result;
			});

			foreach ($this->cAll[$key] as $dao) {
				if ($dao->countryCode) {
					$dao->country = $this->countries->getDao()[$dao->countryCode];
				}
			}
		}

		return $this->cAll[$key];
	}
}
