<?php declare(strict_types = 1);

namespace Core\FrontModule\Presenters;

use Core\FrontModule\Model\Search;
use Core\FrontModule\Model\SiteMap;

class DefaultPresenter extends BasePresenter
{
	public function __construct(protected SiteMap $siteMapService, protected Search $search)
	{
	}

	protected function startup(): void
	{
		if ($this->action === 'sitemap') {
			$this->skipSetInitial = true;
		}

		parent::startup();
	}

	public function actionSearch(?string $q = null): void
	{
		if (!$q) {
			$this->template->empty = true;
		} else {
			$this->template->q      = $q;
			$this->template->result = $this->search->search($q);
		}
	}
}
