<?php declare(strict_types = 1);

namespace Core\FrontModule\Presenters;

use Core\Model\Event\RobotsTxtEvent;
use Core\Model\Sites;
use Core\Model\SystemConfig;

class RobotsPresenter extends BasePresenter
{
	public function __construct(protected Sites $sites)
	{
	}

	public function actionDefault(): void
	{
		$content = [
			'User-agent: *',
			'Crawl-delay: 5',
			'Disallow: /*productsFilter*',
			'Disallow: /*list-limit=*',
			'Disallow: /*?q=*',
			'Disallow: /*?do=measuringCodesTurnOn',
			'Disallow: /*?langSwitcher*',
			'Disallow: /admin',
			'Disallow: /assets/admin',
			'Disallow: /assets/admin2',
			'Disallow: /trafficbot.life',
		];

		if (SystemConfig::load('sitemapRules.disallowCurrQuery')) {
			$content[] = 'Disallow: /*curr=*';
		}

		$content = implode("\n", $content);
		$content .= "\n";

		$currentSite = $this->sites->getCurrentSite();
		$domainUrl   = $this->getHttpRequest()->getUrl()->getHost();

		if (SystemConfig::load('autoGenerateSitemap')) {
			foreach ($currentSite->getDomains() as $domain) {
				if ($domainUrl !== $domain->getDomain()) {
					continue;
				}

				$content .= "Sitemap: " . $this->getHttpRequest()->getUrl()->baseUrl . "sitemap-{$currentSite->getIdent()}-default-{$domain->getLang()}.xml\n";
			}
		} else {
			foreach ($currentSite->getDomains() as $domain) {
				if ($domainUrl !== $domain->getDomain()) {
					continue;
				}

				foreach (glob(WWW_DIR . "/sitemap-{$currentSite->getIdent()}-*-{$domain->getLang()}.xml") ?: [] as $file) {
					$content .= "Sitemap: " . str_replace(WWW_DIR . '/', $this->getHttpRequest()->getUrl()->baseUrl, $file) . "\n";
				}
			}
		}

		$this->eventDispatcher->dispatch(new RobotsTxtEvent($content), 'core.generateRobotsTxt');

		header("Content-Type: text/plain");
		echo $content;
		exit;
	}
}
