<?php declare(strict_types = 1);

namespace Core\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20200329172555 extends AbstractMigration
{
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{

		$this->addSql('ALTER TABLE core__country ADD iso3166_1 VARCHAR(3) DEFAULT \'CZE\' NOT NULL');
	}

	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		foreach ($this->connection->fetchAllAssociative("SELECT * from core__country") as $row) {
			$v = 'CZE';
			if (strtolower((string) $row['id']) == 'sk') {
				$v = 'SVK';
			}

			$this->connection->update('core__country', [
				'iso3166_1' => $v,
			], [
				'id' => $row['id'],
			]);
		}
	}

	public function down(Schema $schema): void
	{

		$this->addSql('ALTER TABLE core__country DROP iso3166_1');
	}
}
