<?php declare(strict_types = 1);

namespace Core\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20211206131016 extends AbstractMigration
{
	protected array $logos = [];

	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{

		foreach ($this->connection->fetchAllAssociative("SELECT ident, logo FROM core__site") as $row)
			$this->logos[$row['ident']] = $row['logo'];

		$this->addSql(
			'ALTER TABLE core__site_text ADD logo VARCHAR(255) DEFAULT NULL, ADD inverse_logo VARCHAR(255) DEFAULT NULL',
		);
		$this->addSql('ALTER TABLE core__site DROP logo ');
	}

	public function postUp(Schema $schema): void
	{
		foreach ($this->logos as $ident => $logo) {
			$this->connection->update('core__site_text', [
				'logo' => $logo,
			], [
				'site' => $ident,
			]);
		}

		parent::postUp($schema);
	}

	public function down(Schema $schema): void
	{

		$this->addSql('ALTER TABLE core__site ADD logo VARCHAR(255) DEFAULT NULL');
		$this->addSql('ALTER TABLE core__site_text DROP logo, DROP inverse_logo');
	}
}
