<?php declare(strict_types = 1);

namespace Core\Migrations;

use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Exception;
use Tracy\Debugger;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
class Version20220114212530 extends AbstractMigration
{
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
	}

	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);
		try {
			$this->connection->transactional(function(Connection $connection) {
				$count = $this->connection->fetchOne(
					'SELECT COUNT(*) FROM `core__cookie_additional_service` WHERE `ident` = \'youtube\'',
				);

				if ($count === 0) {
					$sites = $this->connection->fetchAllAssociative('SELECT `ident` FROM `core__site`');

					$this->connection->insert('core__cookie_additional_service', [
						'ident' => 'youtube',
						'name'  => 'YouTube',
					]);

					$serviceId = $this->connection->lastInsertId();

					foreach ($sites as $site) {
						$this->connection->insert('core__cookie_additional_service_in_site', [
							'cookie_additional_service_id' => $serviceId,
							'site_id'                      => $site['ident'],
						]);
					}
				}
			});
		} catch (Exception $exception) {
			Debugger::log($exception);
		}
	}

	public function down(Schema $schema): void
	{

		$this->addSql('DELETE FROM `core__cookie_additional_service` WHERE `ident` =  `youtube`');
	}
}
