<?php declare(strict_types = 1);

namespace Core\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Nette\Neon\Neon;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20230517101021 extends AbstractMigration
{
	protected array $names = [];

	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		foreach ($this->connection->fetchAllAssociative("SELECT id, name FROM core__country") as $row) {
			$this->names[$row['id']] = $row['name'];
		}

		$this->addSql('CREATE TABLE core__country_text (lang VARCHAR(255) DEFAULT \'cs\' NOT NULL, country_id VARCHAR(255) NOT NULL, name VARCHAR(255) DEFAULT NULL, INDEX IDX_6E46A4D5F92F3E70 (country_id), PRIMARY KEY(country_id, lang)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE core__country_text ADD CONSTRAINT FK_6E46A4D5F92F3E70 FOREIGN KEY (country_id) REFERENCES core__country (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE core__country DROP name');
	}

	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		$configFile = @file_get_contents(APP_DIR . '/config/app/parameters.neon');
		$appConfig  = Neon::decode((string) $configFile);
		$langs      = $appConfig['parameters']['translation']['whitelist'] ?? ['cs'];

		foreach ($this->names as $id => $name) {
			foreach ($langs as $lang) {
				$this->connection->insert('core__country_text', [
					'country_id' => $id,
					'lang'       => $lang,
					'name'       => $name,
				]);
			}
		}
	}

	public function down(Schema $schema): void
	{
		$this->addSql('DROP TABLE core__country_text');
		$this->addSql('ALTER TABLE core__country ADD name VARCHAR(255) CHARACTER SET utf8mb3 DEFAULT NULL COLLATE `utf8mb3_unicode_ci`');
	}
}
