<?php declare(strict_types = 1);

namespace Core\Model;

use Contributte\Translation\Translator;
use Core\AdminModule\Model\Sites;
use Core\Model\Entities\CookieAdditionalService;
use Core\Model\Helpers\BaseEntityService;
use MeasuringCodes\DI\MeasuringCodesExtension;
use MeasuringCodes\Model\MeasuringCodesConfig;
use Nette\DI\Container;

/**
 * @method CookieAdditionalService|object|null getReference($id)
 * @method CookieAdditionalService[] getAll()
 * @method CookieAdditionalService|null get($id)
 */
class CookieAdditionalServices extends BaseEntityService
{
	protected $entityClass = CookieAdditionalService::class;

	public function __construct(
		protected Container  $container,
		protected Sites      $adminSites,
		protected Settings   $settings,
		protected Translator $translator,
	)
	{
	}

	public function getDefaults(): array
	{
		if (class_exists('\\' . MeasuringCodesExtension::class)) {
			$codesOnSites = [];
			$sites        = $this->adminSites->getAll();
			foreach ((array) MeasuringCodesConfig::load('typesList') ?: [] as $key => $row) {
				if (!$row['enable']) {
					continue;
				}

				foreach ($sites as $site) {
					$settings = $this->settings->get(
						'measuringCodes' . ucfirst($site->getIdent()) . ucfirst((string) $key),
						null,
						false,
					);

					if (!$settings || !is_array($settings)) {
						continue;
					}

					$skip = true;
					foreach ($settings as $lang => $s) {
						if ($s['enable']) {
							$skip = false;
							break;
						}
					}
					if (!$skip) {
						$codesOnSites[$key][] = $site->getIdent();
					}
				}
			}
			$result = [];
			foreach ($codesOnSites as $key => $sites) {
				$result[$key] = [
					'id'        => $key,
					'name'      => $this->translator->translate(sprintf('measuringCodes.types.%s.name', $key)),
					'isDefault' => true,
					'sites'     => implode(', ', $sites),
				];
			}

			return $result;
		}

		return [];
	}

	public function getAllWithDefaults(): array
	{
		$all      = [];
		$defaults = $this->getDefaults();
		foreach ($this->getAll() as $item) {
			if (!array_key_exists($item->ident, $defaults)) {
				$all[$item->ident] = ['id'    => $item->ident, 'name' => $item->name, 'isDefault' => false,
				                      'sites' => implode(', ', $item->getSitesIdent())];
			}
		}

		return $defaults + $all;
	}

	public function removeByIdent(string $ident): bool
	{
		if ($entity = $this->getOneByIndent($ident)) {
			$this->em->remove($entity);
			$this->em->flush();

			return true;
		}

		return false;
	}

	public function getOneByIndent(string $ident): ?CookieAdditionalService
	{
		/** @var CookieAdditionalService|null $entity */
		$entity = $this->getEr()->findOneBy(['ident' => $ident]);

		return $entity;
	}

}
