<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'core__country_text')]
#[ORM\Entity]
class CountryText
{
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Country::class, inversedBy: 'texts')]
	#[ORM\JoinColumn(referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	protected Country $country;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 255, nullable: false, options: ['default' => 'cs'])]
	protected string $lang = 'cs';

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $name = null;

	public function __construct(Country $country, string $lang = 'cs')
	{
		$this->country = $country;
		$this->lang    = $lang;
	}

	public function getCountry(): Country { return $this->country; }

	public function getLang(): string { return $this->lang; }
}
