<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\ORM\Proxy;
use Doctrine\ORM\Query;
use Doctrine\ORM\Query as DoctrineQuery;
use Doctrine\ORM\Decorator\EntityManagerDecorator as NettrineEM;

/**
 * @method EntityRepository getRepository($className)
 */
class EntityManagerDecorator extends NettrineEM
{
	public static bool $useDoctrineQuery = false;

	public function createQueryBuilder(): \Doctrine\ORM\QueryBuilder
	{
		return new QueryBuilder($this);
	}

	public function createQuery(string $dql = ''): DoctrineQuery
	{
		if (self::$useDoctrineQuery) {
			$query = new DoctrineQuery($this);
		} else {
			$query = new Query($this);
		}

		if (!empty($dql)) {
			$query->setDQL($dql);
		}

		return $query;
	}
}
