<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine;
use Doctrine\ORM\AbstractQuery;
use Doctrine\ORM\Proxy\Proxy;

class EntityRepository extends Doctrine\ORM\EntityRepository
{
	/**
	 *
	 * @return array
	 */
	public function findPairs(
		string|array $criteria,
		?string      $value = null,
		string|array $orderBy = [],
		?string      $key = null,
	)
	{
		if (!is_array($criteria)) {
			$key      = is_array($orderBy) ? (string) $orderBy[0] : $orderBy;
			$orderBy  = $value;
			$value    = $criteria;
			$criteria = [];
		}

		if (!is_array($orderBy)) {
			$key     = (string) $orderBy;
			$orderBy = [];
		}

		if (empty($key)) {
			$key = $this->getClassMetadata()->getSingleIdentifierFieldName();
		}

		/** @var QueryBuilder $qb */
		$qb = $this->createQueryBuilder('e');

		$qb->whereCriteria($criteria)
			->select(["e.$value", "e.$key"])
			->resetDQLPart('from')->from($this->getEntityName(), 'e', 'e.' . $key);
		$query = $qb->autoJoinOrderBy($orderBy)->getQuery();

		return array_map(static fn($row) => reset($row), $query->getResult(AbstractQuery::HYDRATE_ARRAY));
	}

	public function getReference(int|string $id): ?object
	{
		/** @var object|null $reference */
		$reference = isset($this->_entityName) && class_exists($this->_entityName) ? $this->getEntityManager()->getReference($this->_entityName, $id) : null;

		return $reference;
	}

	public function createQueryBuilder($alias, $indexBy = null): QueryBuilder
	{
		$qb = new QueryBuilder($this->getEntityManager());
		$qb->select($alias)
			->from($this->getEntityName(), $alias, $indexBy);

		return $qb;
	}
}
