<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use DateTime;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'core__public_holiday')]
#[ORM\Entity]
#[ORM\EntityListeners([TranslateListener::class])]
class PublicHoliday
{
	use TTranslateListener;
	use TId;

	#[ORM\Column(type: Types::DATE_MUTABLE, unique: true, nullable: false)]
	public DateTime $date;

	/** @var Collection<string, PublicHolidayText> */
	#[ORM\OneToMany(mappedBy: 'publicHoliday', targetEntity: PublicHolidayText::class, indexBy: 'lang')]
	public Collection $texts;

	#[ORM\ManyToOne(targetEntity: Country::class)]
	#[ORM\JoinColumn(referencedColumnName: 'id', nullable: true, onDelete: 'SET NULL')]
	public ?Country $country = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $source = null;

	public function __construct(DateTime $date)
	{
		$this->date  = $date;
		$this->texts = new ArrayCollection();
	}

	public function getText(?string $lang = null): ?PublicHolidayText { return $this->texts[$lang ?: $this->locale] ?? null; }

	/** @return Collection<string, PublicHolidayText> */
	public function getTexts(): Collection { return $this->texts; }
}
