<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Core\FrontModule\Model\SiteMap;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\ArrayHash;

#[ORM\Table(name: 'core__seo')]
#[ORM\Entity]
class Seo
{
	use TId;

	#[ORM\Column(name: 'title', type: Types::STRING, length: 255, nullable: true)]
	public ?string $title = null;

	#[ORM\Column(name: 'description', type: Types::STRING, length: 255, nullable: true)]
	public ?string $description = null;

	#[ORM\Column(name: 'robots', type: Types::STRING, length: 255, nullable: false, options: ['default' => 'index, follow'])]
	public string $robots = 'index, follow';

	#[ORM\Column(name: 'canonical', type: Types::STRING, length: 255, nullable: false, options: ['default' => 'self'])]
	public string $canonical = 'self';

	#[ORM\Column(name: 'add_to_site_map', type: Types::SMALLINT, nullable: false, options: ['default' => 1, 'unsigned' => true])]
	public int $addToSiteMap = 1;

	#[ORM\Column(name: 'site_map_change_freq', type: Types::STRING, length: 255, nullable: false, options: ['default' => 'monthly'])]
	public string $siteMapChangeFreq = SiteMap::CHANGE_FREQ_MONTHLY;

	#[ORM\Column(name: 'site_map_priority', type: Types::STRING, length: 255, nullable: false, options: ['default' => '0.5'])]
	public string $siteMapPriority = '0.5';
}
