<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'core__site_text')]
#[ORM\Index(columns: ['is_active', 'is_default'], name: 'search_idx')]
#[ORM\Entity]
class SiteText
{
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Site::class, inversedBy: 'texts')]
	#[ORM\JoinColumn(name: 'site', referencedColumnName: 'ident', nullable: false, onDelete: 'CASCADE')]
	protected Site $site;

	#[ORM\Id]
	#[ORM\Column(name: 'lang', type: Types::STRING, length: 255, nullable: false, options: ['default' => 'cs'])]
	protected string $lang;

	#[ORM\Column(name: 'domain', type: Types::STRING, length: 255, nullable: false)]
	public string $domain;

	#[ORM\Column(name: 'site_name', type: Types::STRING, length: 255, nullable: true)]
	public ?string $siteName = null;

	#[ORM\Column(name: 'logo', type: Types::STRING, length: 255, nullable: true)]
	public ?string $logo = null;

	#[ORM\Column(name: 'inverse_logo', type: Types::STRING, length: 255, nullable: true)]
	public ?string $inverseLogo = null;

	#[ORM\Column(name: 'is_default', type: Types::SMALLINT, length: 1, nullable: false, options: ['default' => 0])]
	public int $isDefault = 0;

	#[ORM\Column(name: 'is_active', type: Types::SMALLINT, length: 1, nullable: false, options: ['default' => 1])]
	public int $isActive = 1;

	#[ORM\Column(name: 'default_country', type: Types::STRING, length: 3, nullable: true)]
	public ?string $defaultCountry = null;

	#[ORM\Column(name: 'default_currency_code', type: Types::STRING, length: 3, nullable: true)]
	public ?string $defaultCurrency = null;

	#[ORM\Column(name: 'disable_index', type: Types::SMALLINT, length: 1, nullable: false, options: ['default' => 0])]
	public int $disableIndex = 0;

	public function __construct(Site $site, string $domain, string $lang = 'cs')
	{
		$this->site      = $site;
		$this->domain    = $domain;
		$this->lang      = $lang;
		$this->isDefault = 0;
	}

	public function getSite(): Site { return $this->site; }

	public function getLang(): string { return $this->lang; }
}
