<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'core__static_text_translation')]
#[ORM\Entity]
class StaticTextTranslation
{
	#[ORM\Id]
	#[ORM\Column(type: Types::INTEGER, nullable: false)]
	#[ORM\GeneratedValue]
	public ?int $messageId = null;

	#[ORM\Column(type: Types::STRING, nullable: false)]
	public string $id;

	#[ORM\Column(type: Types::STRING, nullable: false)]
	public string $locale;

	#[ORM\Column(type: Types::STRING, nullable: false)]
	public string $message;

	public function __construct(string $id, string $locale, string $message)
	{
		$this->id      = $id;
		$this->locale  = $locale;
		$this->message = $message;
	}

}
