<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

trait TId
{
	#[ORM\Column(type: Types::INTEGER, nullable: false)]
	#[ORM\Id]
	#[ORM\GeneratedValue]
	private ?int $id = null;

	public function getId(): ?int
	{
		return $this->id;
	}

	public function __clone()
	{
		$this->id = null;
	}
}
