<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

trait TLang
{
	#[ORM\Column(type: Types::STRING, length: 2, nullable: true)]
	public ?string $lang = null;

	public function getLang(): ?string { return $this->lang; }

	public function setLang(?string $lang): void
	{
		if ($lang === '') {
			$this->lang = null;
		} else {
			$this->lang = $lang;
		}
	}
}
