<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'core__translate_field')]
#[ORM\Entity]
class TranslateField
{
	#[ORM\Id]
	#[ORM\Column(name: '`key`', type: Types::STRING, length: 255, nullable: false)]
	public string $key;

	#[ORM\Id]
	#[ORM\Column(name: '`locale`', type: Types::STRING, length: 255, nullable: false)]
	public string $locale;

	#[ORM\Column(name: 'is_locked', type: Types::SMALLINT, length: 1, nullable: false, options: ['default' => 0])]
	public int $isLocked = 0;
}
