<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use DateTime;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Users\Model\Entities\User;

#[ORM\Table(name: 'core__translate_log')]
#[ORM\Entity]
class TranslateLog
{
	use TIdUnsigned;

	#[ORM\Column(name: 'source_locale', type: Types::STRING, length: 2, nullable: false)]
	public string $sourceLocale;

	#[ORM\Column(name: 'target_locale', type: Types::STRING, length: 2, nullable: false)]
	public string $targetLocale;

	#[ORM\Column(name: 'source_text', type: Types::TEXT, nullable: false)]
	public string $sourceText;

	#[ORM\Column(name: 'target_text', type: Types::TEXT, nullable: false)]
	public string $targetText;

	#[ORM\ManyToOne(targetEntity: User::class)]
	#[ORM\JoinColumn(name: 'user', referencedColumnName: 'id', nullable: true, onDelete: 'SET NULL')]
	public ?User $userId = null;

	#[ORM\Column(name: 'user_email', type: Types::STRING, length: 255, nullable: true)]
	public ?string $userEmail = null;

	#[ORM\Column(name: 'billed_characters', type: Types::INTEGER, nullable: false, options: ['default' => 0, 'unsigned' => true])]
	public int $billedCharacters = 0;

	#[ORM\Column(name: 'created_at', type: Types::DATETIME_MUTABLE, nullable: false, options: ['default' => 'CURRENT_TIMESTAMP'])]
	public DateTime $createdAt;
}
