<?php declare(strict_types = 1);

namespace Core\Model\Event;

use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Symfony\Contracts\EventDispatcher\Event;

class ApiShutdownEvent extends Event
{
	protected ServerRequestInterface $request;
	protected ResponseInterface      $response;

	public function __construct(
		ServerRequestInterface $request,
		ResponseInterface      $response
	)
	{
		$this->request  = $request;
		$this->response = $response;
	}
}
