<?php declare(strict_types = 1);

namespace Core\Model\Event;

use Symfony\Contracts\EventDispatcher\Event;

class EntityRemoveEvent extends Event
{
	public string $entityId;
	public object $entity;
	public array  $data = [];

	public function __construct(string $entityId, object $entity, array $data = [])
	{
		$this->entityId = $entityId;
		$this->entity   = $entity;
		$this->data     = $data;
	}
}
