<?php declare(strict_types = 1);

namespace Core\Model\Event;

use Core\Model\Templating\Template;
use Core\Model\UI\AbstractPresenter;
use Core\Model\UI\Form\BaseForm;
use Nette\Application\UI\Control;
use Nette\Utils\ArrayHash;
use Symfony\Contracts\EventDispatcher\Event;

class FormSuccessEvent extends Event
{
	public ?Control $control = null;
	public array    $custom  = [];

	public function __construct(
		public BaseForm           $form,
		public ArrayHash          $values,
		public ?Template          $template,
		public ?AbstractPresenter $presenter,
	)
	{
	}
}
