<?php declare(strict_types = 1);

namespace Core\Model\Event;

use Symfony\Contracts\EventDispatcher\Event;
use Core\Model\Entities\QueryBuilder;
use Doctrine\Common\Collections\Criteria;

class GridFilterEvent extends Event
{
	public QueryBuilder $queryBuilder;

	public Criteria $criteria;

	public function __construct(QueryBuilder $queryBuilder, Criteria $criteria, public mixed $value)
	{
		$this->queryBuilder = &$queryBuilder;
		$this->criteria     = &$criteria;
	}
}
